unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AHMDialogClass, AHMTSerialNumber;

type
  TForm1 = class(TForm)
    AHMSerialNumber1: TAHMSerialNumber;
    Label1: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure AHMSerialNumber1WrongCode(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AHMSerialNumber1RightCode(Sender: TObject);
    procedure AHMSerialNumber1Cancel(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Counter : Integer = 3;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.AHMSerialNumber1WrongCode(Sender: TObject);
begin
  dec(Counter);
  if Counter>0 then showmessage('Wrong serial number. You can try '+inttostr(Counter)+' more time(s).')
  else AHMSerialNumber1Cancel(Self);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  AHMSerialNumber1.Execute;
end;

procedure TForm1.AHMSerialNumber1RightCode(Sender: TObject);
begin
  Showmessage('Thank you for entering the serial number');
end;

procedure TForm1.AHMSerialNumber1Cancel(Sender: TObject);
begin
  Showmessage('You have not entered a correct serial number. This application will now exit.');
  Halt;
end;

end.
